/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.startup;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.servlet.helptools.HelpSupport;
import com.ibm.hwmca.fw.shutdown.ShutdownDialog;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.IniFileProcessor;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BobcatStartupServlet
extends HttpServlet {
    private static final String TRACE_MASKT = "XFRMUNIT";
    private static final String TRACE_MASKF = "XFRMUNIF";
    private static final String START_INI_FILE_NAME = "clientstart.ini";

    public void init() throws ServletException {
        Trace.trace(TRACE_MASKT, "-> BobcatStartupServlet.init");
        try {
            Class.forName("com.ibm.hwmca.fw.system.Manager");
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "Exception loading Manager class");
            Trace.trace(TRACE_MASKT, e);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "Loaded the class.. setting location");
        CommonSystem.getCommonSystem().setLocation(3);
        Trace.trace(TRACE_MASKF, "set location.. starting manager");
        Manager.main(new String[0]);
        Trace.trace(TRACE_MASKF, "back from Manager.main");
        Manager manager = Manager.getManager();
        Trace.trace(TRACE_MASKF, "got manager.. waiting until safe");
        manager.waitUntilSafeForClient();
        Trace.trace(TRACE_MASKF, "safe!!!");
        if (!manager.managerStartupSucceeded()) {
            Trace.trace(TRACE_MASKT, "Exiting due to unsuccessful Manager startup");
            System.exit(102);
        }
        HelpSupport.prepareHelpWebapp();
        try {
            ClientUserContext cuc = new ClientUserContext(new ConnectionFactory(CommonSystem.getCommonSystem().getManagerHost(), 9940));
            cuc.attachToThread(true);
        }
        catch (UnknownHostException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        IniFileProcessor.runClasses(START_INI_FILE_NAME, "Client INI");
        try {
            ShutdownDialog.destroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        BrowserRespawnThread browserThread = null;
        boolean startBrowser = System.getProperty("START_BROWSER", "true").equals("true");
        if (startBrowser) {
            browserThread = new BrowserRespawnThread();
            browserThread.start();
        }
        Trace.trace(TRACE_MASKT, "The unified startup main thread is ending");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "<> BobcatStartupServlet.doGet");
    }

    class BrowserRespawnThread
    extends Thread {
        Process browserProcess;
        boolean stopped = false;
        boolean browserRunning = true;

        BrowserRespawnThread() {
            super("Local browser process spawner");
        }

        public void run() {
            Trace.trace(BobcatStartupServlet.TRACE_MASKT, "-> BrowserRespawnThread.run");
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: starting browser for the first time.. pointing at preLogon servlet");
            this.removeLockFile();
            String mozillaCmd = System.getProperty("DEVELOPMENT_SYSTEM", "no").equalsIgnoreCase("yes") ? "mozilla" : "mozilla -P default";
            boolean usingSSL = System.getProperty("USING_APACHE_SSL", "false").equalsIgnoreCase("true");
            try {
                this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + " http://127.0.0.1:8080/prelogon.html");
            }
            catch (IOException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: failed to start browser.");
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
                return;
            }
            while (true) {
                this.browserRunning = true;
                while (this.browserRunning) {
                    try {
                        this.browserProcess.waitFor();
                        Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: browser returned.");
                        this.browserRunning = false;
                    }
                    catch (InterruptedException e) {}
                }
                if (this.stopped) break;
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: respawning browser.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.removeLockFile();
                try {
                    this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + " http://127.0.0.1:8080/localindex.html");
                }
                catch (IOException e) {
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: failed to start browser");
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
                    return;
                }
            }
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "<- BrowserRespawnThread.run");
        }

        private void removeLockFile() {
            Trace.trace(BobcatStartupServlet.TRACE_MASKT, "-> BrowserRespawnThread.removeLockFile()");
            try {
                String script = BaseFileControl.getFilePath("runAsRoot") + "removeMozillaLockFile.sh";
                Process p = Runtime.getRuntime().exec(script);
                int rc = 0;
                boolean done = false;
                while (!done) {
                    try {
                        rc = p.waitFor();
                        done = true;
                    }
                    catch (InterruptedException e) {}
                }
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread.removeLockFile: script returned " + rc);
            }
            catch (HException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
            catch (IOException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
            Trace.trace(BobcatStartupServlet.TRACE_MASKT, "<- BrowserRespawnThread.removeLockFile()");
        }

        void stopBrowser() {
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "<> BrowserRespawnThread.stopBrowser()");
            this.stopped = true;
            this.browserProcess.destroy();
            try {
                Runtime.getRuntime().exec("killall -15 mozilla-bin");
            }
            catch (IOException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespansThread.stopBrowser: failed to kill mozilla-bin");
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
        }
    }
}

